/*
 * Decompiled with CFR 0.152.
 */
package br.com.backmap.mapback.controller;

import br.com.backmap.mapback.DTO.AuthenticationDTO;
import br.com.backmap.mapback.DTO.LoginResponseDTO;
import br.com.backmap.mapback.DTO.RegisterDTO;
import br.com.backmap.mapback.model.Usuario;
import br.com.backmap.mapback.repository.UsuarioRepository;
import br.com.backmap.mapback.security.TokenService;
import br.com.backmap.mapback.service.InvalidCpfCnpjException;
import br.com.backmap.mapback.service.UsuarioService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"auth"})
public class AuthenticationController {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private UsuarioRepository repository;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private UsuarioService usuarioService;

    @PostMapping(value={"/login"})
    public ResponseEntity<LoginResponseDTO> login(@RequestBody AuthenticationDTO data) {
        UsernamePasswordAuthenticationToken usernamePassword = new UsernamePasswordAuthenticationToken((Object)data.email(), (Object)data.senha());
        Authentication auth = this.authenticationManager.authenticate((Authentication)usernamePassword);
        String token = this.tokenService.generateToken((Usuario)auth.getPrincipal());
        return ResponseEntity.ok((Object)new LoginResponseDTO(token));
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<String> register(@RequestBody RegisterDTO data) {
        if (this.repository.findByEmail(data.email()) != null) {
            return ResponseEntity.badRequest().body((Object)"Email j\u00e1 existe");
        }
        String encryptedPassword = new BCryptPasswordEncoder().encode((CharSequence)data.senha());
        Usuario newUser = new Usuario(data.email(), encryptedPassword, data.role(), data.cpf(), data.nome(), data.telefone());
        try {
            this.usuarioService.cadastrarUsuario(newUser);
        }
        catch (InvalidCpfCnpjException e) {
            return ResponseEntity.badRequest().body((Object)("Erro ao cadastrar usu\u00e1rio: " + e.getMessage()));
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body((Object)("Erro ao cadastrar usu\u00e1rio: " + e.getMessage()));
        }
        return ResponseEntity.ok((Object)"Usu\u00e1rio cadastrado com sucesso");
    }
}

