/*
 * Decompiled with CFR 0.152.
 */
package br.com.backmap.mapback.controller;

import br.com.backmap.mapback.model.Jogo;
import br.com.backmap.mapback.service.JogoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/jogos"})
public class JogoController {
    @Autowired
    private JogoService jogoService;

    @GetMapping
    public ResponseEntity<List<Jogo>> listarJogos() {
        List jogos = this.jogoService.listarJogos();
        return new ResponseEntity((Object)jogos, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Jogo> buscarJogoPorId(@PathVariable Long id) {
        Optional jogo = this.jogoService.buscarJogoPorId(id);
        return jogo.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<Jogo> cadastrarJogo(@RequestBody Jogo jogo) {
        Jogo jogoSalvo = this.jogoService.salvarJogo(jogo);
        return new ResponseEntity((Object)jogoSalvo, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Jogo> atualizarJogo(@PathVariable Long id, @RequestBody Jogo jogoAtualizado) {
        Optional jogo = this.jogoService.buscarJogoPorId(id);
        if (jogo.isPresent()) {
            Jogo jogoExistente = (Jogo)jogo.get();
            jogoExistente.setFimDeJogo(jogoAtualizado.isFimDeJogo());
            Jogo jogoSalvo = this.jogoService.salvarJogo(jogoExistente);
            return ResponseEntity.ok((Object)jogoSalvo);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletarJogo(@PathVariable Long id) {
        if (this.jogoService.existeJogo(id)) {
            this.jogoService.deletarJogo(id);
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

