/*
 * Decompiled with CFR 0.152.
 */
package br.com.backmap.mapback.controller;

import br.com.backmap.mapback.model.Jogo;
import br.com.backmap.mapback.model.QrCodeResponse;
import br.com.backmap.mapback.model.Usuario;
import br.com.backmap.mapback.repository.JogoRepository;
import br.com.backmap.mapback.service.AsaasIntegrationService;
import br.com.backmap.mapback.service.UsuarioService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/usuarios"})
public class UsuarioController {
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private JogoRepository jogoRepository;
    @Autowired
    private AsaasIntegrationService asaasIntegrationService;

    @GetMapping
    public ResponseEntity<List<Usuario>> listarUsuarios() {
        List usuarios = this.usuarioService.listarUsuarios();
        return new ResponseEntity((Object)usuarios, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Usuario> buscarUsuarioPorId(@PathVariable Long id) {
        Optional usuario = this.usuarioService.buscarUsuarioPorId(id);
        return usuario.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<Usuario> cadastrarUsuario(@RequestBody Usuario usuario) {
        Usuario usuarioSalvo = this.usuarioService.salvarUsuario(usuario);
        return new ResponseEntity((Object)usuarioSalvo, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Usuario> atualizarUsuario(@PathVariable Long id, @RequestBody Usuario usuarioAtualizado) {
        Optional usuario = this.usuarioService.buscarUsuarioPorId(id);
        if (usuario.isPresent()) {
            Usuario usuarioExistente = (Usuario)usuario.get();
            usuarioExistente.setNome(usuarioAtualizado.getNome());
            usuarioExistente.setEmail(usuarioAtualizado.getEmail());
            usuarioExistente.setMensagem(usuarioAtualizado.getMensagem());
            Usuario usuarioSalvo = this.usuarioService.salvarUsuario(usuarioExistente);
            return ResponseEntity.ok((Object)usuarioSalvo);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletarUsuario(@PathVariable Long id) {
        if (this.usuarioService.existeUsuario(id)) {
            this.usuarioService.deletarUsuario(id);
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/{id}/gerar-cobranca"})
    public ResponseEntity<Object> gerarCobranca(@PathVariable Long id) {
        Optional usuarioOptional = this.usuarioService.buscarUsuarioPorId(id);
        if (usuarioOptional.isPresent()) {
            Usuario usuario = (Usuario)usuarioOptional.get();
            try {
                String cobrancaId = this.asaasIntegrationService.gerarCobranca(usuario);
                return ResponseEntity.ok().body((Object)("{\"message\": \"Cobran\u00e7a gerada com sucesso. ID: " + cobrancaId + "\"}"));
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Erro ao gerar cobran\u00e7a: " + e.getMessage() + "\"}"));
            }
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/obter-qrcode-pix"})
    public ResponseEntity<Object> obterQrCodePix(@PathVariable Long id) {
        Optional usuarioOptional = this.usuarioService.buscarUsuarioPorId(id);
        if (usuarioOptional.isPresent()) {
            Usuario usuario = (Usuario)usuarioOptional.get();
            try {
                QrCodeResponse qrCodeResponse = this.asaasIntegrationService.obterQrCodePix(usuario);
                return ResponseEntity.ok().body((Object)qrCodeResponse);
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Erro ao obter QR Code do PIX: " + e.getMessage() + "\"}"));
            }
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/{id}/atualizar-etapa"})
    public ResponseEntity<Object> atualizarEtapa(@PathVariable Long id, @RequestParam String novaEtapa) {
        try {
            Usuario usuarioAtualizado = this.usuarioService.atualizarEtapa(id, novaEtapa);
            return ResponseEntity.ok().body((Object)("{\"message\": \"Etapa atualizada com sucesso.\", \"novaEtapa\": \"" + usuarioAtualizado.getEtapa() + "\"}"));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Erro ao atualizar etapa: " + e.getMessage() + "\"}"));
        }
    }

    @GetMapping(value={"/{id}/etapa"})
    public ResponseEntity<Object> obterEtapa(@PathVariable Long id) {
        Optional usuarioOptional = this.usuarioService.buscarUsuarioPorId(id);
        if (usuarioOptional.isPresent()) {
            Usuario usuario = (Usuario)usuarioOptional.get();
            String etapa = usuario.getEtapa();
            return ResponseEntity.ok().body((Object)("{\"etapa\": \"" + etapa + "\"}"));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"{\"error\": \"Usu\u00e1rio n\u00e3o encontrado.\"}");
    }

    @PutMapping(value={"/{id}/localizacao"})
    public ResponseEntity<Object> atualizarLocalizacao(@PathVariable Long id, @RequestParam float lat, @RequestParam float lon) {
        Optional usuarioOptional = this.usuarioService.buscarUsuarioPorId(id);
        if (usuarioOptional.isPresent()) {
            Usuario usuario = (Usuario)usuarioOptional.get();
            usuario.setLat(lat);
            usuario.setLon(lon);
            this.usuarioService.salvarUsuario(usuario);
            return ResponseEntity.ok().body((Object)("{\"message\": \"Localiza\u00e7\u00e3o atualizada com sucesso.\", \"lat\": " + lat + ", \"lon\": " + lon + "}"));
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/localizacao"})
    public ResponseEntity<Object> obterLocalizacao(@PathVariable Long id) {
        Optional usuarioOptional = this.usuarioService.buscarUsuarioPorId(id);
        if (usuarioOptional.isPresent()) {
            Usuario usuario = (Usuario)usuarioOptional.get();
            return ResponseEntity.ok().body((Object)("{\"lat\": " + usuario.getLat() + ", \"lon\": " + usuario.getLon() + "}"));
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/fim"})
    public ResponseEntity<Object> verificarFim(@PathVariable Long id) {
        Optional jogoOptional = this.jogoRepository.findById((Object)id);
        if (jogoOptional.isPresent()) {
            Jogo jogo = (Jogo)jogoOptional.get();
            boolean fim = jogo.isFimDeJogo();
            return ResponseEntity.ok().body((Object)("{\"fim\": " + fim + "}"));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"{\"error\": \"Jogo n\u00e3o encontrado.\"}");
    }

    @PostMapping(value={"/finalizar-todos"})
    public ResponseEntity<Object> finalizarTodosUsuarios() {
        try {
            this.usuarioService.finalizarTodosUsuarios();
            return ResponseEntity.ok().body((Object)"{\"message\": \"Todos os usu\u00e1rios foram finalizados com sucesso.\"}");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Erro ao finalizar usu\u00e1rios: " + e.getMessage() + "\"}"));
        }
    }

    @PostMapping(value={"/reset-senha"})
    public ResponseEntity<Object> resetSenha(@RequestParam String email) {
        try {
            this.usuarioService.solicitarResetSenha(email);
            return ResponseEntity.ok().body((Object)"{\"message\": \"Instru\u00e7\u00f5es para reset de senha enviadas com sucesso.\"}");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("{\"error\": \"Erro ao solicitar reset de senha: " + e.getMessage() + "\"}"));
        }
    }

    @PostMapping(value={"/alterar-senha"})
    public ResponseEntity<Object> alterarSenha(@RequestParam String email, @RequestParam int resetCode, @RequestParam String novaSenha) {
        try {
            boolean sucesso = this.usuarioService.alterarSenha(email, resetCode, novaSenha);
            if (sucesso) {
                return ResponseEntity.ok().body((Object)"{\"message\": \"Senha alterada com sucesso.\"}");
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"{\"error\": \"C\u00f3digo de redefini\u00e7\u00e3o inv\u00e1lido ou e-mail n\u00e3o encontrado.\"}");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Erro ao alterar a senha: " + e.getMessage() + "\"}"));
        }
    }
}

