/*
 * Decompiled with CFR 0.152.
 */
package br.com.backmap.mapback.security;

import br.com.backmap.mapback.model.Usuario;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    @Value(value="${api.security.token.secret}")
    private String secret;

    public String generateToken(Usuario user) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            String token = JWT.create().withIssuer("auth-api").withSubject(user.getEmail()).withClaim("id", user.getId()).withExpiresAt(this.genExpirationDate()).sign(algorithm);
            return token;
        }
        catch (JWTCreationException exception) {
            throw new RuntimeException("Error while generating token", exception);
        }
    }

    public String validateToken(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            return JWT.require((Algorithm)algorithm).withIssuer("auth-api").build().verify(token).getSubject();
        }
        catch (JWTVerificationException exception) {
            return "";
        }
    }

    private Instant genExpirationDate() {
        return LocalDateTime.now().plusHours(48L).toInstant(ZoneOffset.of("-03:00"));
    }
}

