/*
 * Decompiled with CFR 0.152.
 */
package br.com.backmap.mapback.service;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    @Autowired
    private JavaMailSender mailSender;

    public void sendWelcomeEmail(String to, String userName) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom("contato@biscoitodasorte.online");
            helper.setTo(to);
            helper.setSubject("Seja muito bem vindo!");
            String htmlContent = this.loadHtmlFromResource("welcome_email.html");
            htmlContent = htmlContent.replace("{userName}", userName);
            helper.setText(htmlContent, true);
            this.mailSender.send(message);
            System.out.println("E-mail de boas-vindas enviado com sucesso para: " + to);
        }
        catch (MessagingException | IOException e) {
            e.printStackTrace();
            System.err.println("Erro ao enviar e-mail de boas-vindas: " + e.getMessage());
        }
    }

    public void sendPaymentConfirmationEmail(String to, String userName) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom("contato@biscoitodasorte.online");
            helper.setTo(to);
            helper.setSubject("Confirma\u00e7\u00e3o de Pagamento");
            String htmlContent = this.loadHtmlFromResource("payment_confirmation.html");
            htmlContent = htmlContent.replace("{userName}", userName);
            helper.setText(htmlContent, true);
            this.mailSender.send(message);
            System.out.println("E-mail de confirma\u00e7\u00e3o de pagamento enviado com sucesso para: " + to);
        }
        catch (MessagingException | IOException e) {
            e.printStackTrace();
            System.err.println("Erro ao enviar e-mail de confirma\u00e7\u00e3o de pagamento: " + e.getMessage());
        }
    }

    public void sendPasswordResetEmail(String to, String userName, String resetCode) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom("contato@biscoitodasorte.online");
            helper.setTo(to);
            helper.setSubject("Redefini\u00e7\u00e3o de Senha");
            String htmlContent = this.loadHtmlFromResource("password_reset.html");
            htmlContent = htmlContent.replace("{userName}", userName).replace("{resetCode}", resetCode);
            helper.setText(htmlContent, true);
            this.mailSender.send(message);
            System.out.println("E-mail de redefini\u00e7\u00e3o de senha enviado com sucesso para: " + to);
        }
        catch (MessagingException | IOException e) {
            e.printStackTrace();
            System.err.println("Erro ao enviar e-mail de redefini\u00e7\u00e3o de senha: " + e.getMessage());
        }
    }

    private String loadHtmlFromResource(String resourceName) throws IOException {
        ClassPathResource resource = new ClassPathResource(resourceName);
        try (InputStream inputStream = resource.getInputStream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }
}

