/*
 * Decompiled with CFR 0.152.
 */
package br.com.backmap.mapback.service;

import br.com.backmap.mapback.DTO.PaymentWebhookDTO;
import br.com.backmap.mapback.model.Usuario;
import br.com.backmap.mapback.repository.UsuarioRepository;
import br.com.backmap.mapback.service.EmailService;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private EmailService emailService;

    public void handlePaymentWebhook(PaymentWebhookDTO webhookDTO) {
        String paymentId = webhookDTO.getPayment().getId();
        String paymentStatus = webhookDTO.getPayment().getStatus();
        Optional optionalUsuario = this.usuarioRepository.findByCodPagamento(paymentId);
        if (optionalUsuario.isPresent()) {
            Usuario usuario = (Usuario)optionalUsuario.get();
            if ("RECEIVED".equals(paymentStatus)) {
                usuario.setStatusPagamento("PAGO");
                this.emailService.sendPaymentConfirmationEmail(usuario.getEmail(), usuario.getNome());
            } else {
                usuario.setStatusPagamento("PENDENTE");
            }
            this.usuarioRepository.save((Object)usuario);
        } else {
            System.out.println("User not found with payment ID: " + paymentId);
        }
    }
}

