/*
 * Decompiled with CFR 0.152.
 */
package br.com.backmap.mapback.service;

import br.com.backmap.mapback.model.Usuario;
import br.com.backmap.mapback.repository.UsuarioRepository;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ScheduledService {
    @Autowired
    private UsuarioRepository usuarioRepository;
    private static final LocalDateTime TARGET_TIME = LocalDateTime.of(2024, 11, 9, 15, 36);
    private static final ZoneId BRAZIL_ZONE = ZoneId.of("America/Sao_Paulo");

    @Scheduled(cron="0 * * * * *")
    public void checkScheduledTime() {
        LocalDateTime now = LocalDateTime.now(BRAZIL_ZONE);
        LocalDateTime lowerBound = TARGET_TIME.minusSeconds(30L);
        LocalDateTime upperBound = TARGET_TIME.plusSeconds(30L);
        if (now.isAfter(lowerBound) && now.isBefore(upperBound)) {
            this.clearUserMessages();
        }
    }

    public void clearUserMessages() {
        List usuarios = this.usuarioRepository.findAll();
        for (Usuario usuario : usuarios) {
            usuario.setEtapa("inicio");
        }
        this.usuarioRepository.saveAll((Iterable)usuarios);
        System.out.println("In\u00edcio");
    }
}

